//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "GLWektory.h"
#include "Teksturowanie.h"
#include "GLNapisy.h"

#include "glut.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TGLForm(Owner)
{
   ObslugaMyszy=true;
   KolorTla=clBlack;
   debug_mode=false;
   Mgla=false;
   NieruchomyPokoj=false;
   NieruchomyPokoj_Kolor=clBlue;
   NatezenieSwiatlaOtoczenia=0.5f;
   SwobodneObroty=true;
   SwobodneObrotyWygaszanie=0.0;

   Obracaj(10.0f,1.0f,0.0f);

   //teksturowanie
   //glEnable(GL_TEXTURE_2D);
   Teksturowanie=true;

   AnsiString nazwyPlikow[TEKSTURY_ILOSC]={"Nefryt.bmp"};

   glGenTextures(TEKSTURY_ILOSC,Tekstury); //tworzenie tablicy tekstur
	for(int i=0;i<TEKSTURY_ILOSC;i++)
	{
   	int TeksturaSzer,TeksturaWys;
	   unsigned long* Tekstura=WczytajTeksture(nazwyPlikow[i],TeksturaSzer,TeksturaWys);
	   if (Tekstura!=NULL)
	   {
         glBindTexture(GL_TEXTURE_2D,Tekstury[i]);
		   glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		   glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		   gluBuild2DMipmaps(GL_TEXTURE_2D,3,TeksturaSzer,TeksturaWys,GL_RGBA,GL_UNSIGNED_BYTE,Tekstura);
		   delete[] Tekstura; //oryginalne dane sa usuwane
	   }
   }

   //czcionka 3D
   //czcionkaTimes3D=StworzCzcionke3D(Handle,"Times New Roman CE",false,true);

   //Caption=(AnsiString)"GLForm, OpenGL "+(char*)glGetString(GL_VERSION)+",   F1 - Pomoc";
   Caption="Zobacz: http://en.wikipedia.org/wiki/Utah_teapot";
}

//---------------------------------------------------------------------------

void __fastcall TForm1::RysujScene()
{
   int GL_LIGHT_MODEL_COLOR_CONTROL=0x81F8,
   GL_SINGLE_COLOR=0x81F9,GL_COLOR_SIMPLE=0x81F9,
   GL_SEPARATE_SPECULAR_COLOR=0x81FA;

   const float wsp_odbicia_szklo[4]={1.0,1.0,1.0,1.0};
   const float wsp_odbicia_matowy[4]={0.0,0.0,0.0,1.0};

   glMaterialfv(GL_FRONT,GL_SPECULAR,wsp_odbicia_szklo);
   glMateriali(GL_FRONT,GL_SHININESS,100);
   glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL,GL_SEPARATE_SPECULAR_COLOR); //konieczne, aby tekstury nie psuly

   glPushMatrix(); //zapamietaj macierz model-widok (wloz na stos macierzy)
   glColor4ub(255,255,255,255);
   //RysujSzescian(1.0f);
   glScalef(1.0f,1.3f,1.0f);
   //glutWireTeapot(1.0);
   glutSolidTeapot(1.0);


   /*
   glPopMatrix(); //zdejmij ze stosu macierzy = odtworz zapamietany stan
   glBindTexture(GL_TEXTURE_2D,NULL);
   glTranslatef(-4.0f,0.0f,0.0f);
   glColor3f(0.0f,1.0f,0.0f);
   Teksturowanie=false;
   Pisz((AnsiString)"GLForm, OpenGL "+(char*)glGetString(GL_VERSION),czcionkaTimes3D);
   Teksturowanie=true;
   */

   glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL,GL_SINGLE_COLOR);
   glMaterialfv(GL_FRONT,GL_SPECULAR,wsp_odbicia_matowy);
   glMateriali(GL_FRONT,GL_SHININESS,0);
}

//---------------------------------------------------------------------------

void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   //obroty
   if (Shift.Empty())
   {
      if (Key>='0' && Key<='7')
      {
         GLenum swiatlo=GL_LIGHT0;
         switch (Key)
         {
            case '1': swiatlo=GL_LIGHT1; break;
            case '2': swiatlo=GL_LIGHT2; break;
            case '3': swiatlo=GL_LIGHT3; break;
            case '4': swiatlo=GL_LIGHT4; break;
            case '5': swiatlo=GL_LIGHT5; break;
            case '6': swiatlo=GL_LIGHT6; break;
            case '7': swiatlo=GL_LIGHT7; break;
            default: swiatlo=GL_LIGHT0;
         }
         if (glIsEnabled(swiatlo)) glDisable(swiatlo);
         else glEnable(swiatlo);
      }

      switch (Key)
      {
         case 'b':
         case 'B':
            if (glIsEnabled(GL_BLEND)) glDisable(GL_BLEND);
            else glEnable(GL_BLEND);
            break;
         case 'a':
         case 'A':
            if (glIsEnabled(GL_POINT_SMOOTH))
            {
               glDisable(GL_POINT_SMOOTH);
               glDisable(GL_LINE_SMOOTH);
               glDisable(GL_POLYGON_SMOOTH);
            }
            else
            {
               glEnable(GL_POINT_SMOOTH);
               glEnable(GL_LINE_SMOOTH);
               glEnable(GL_POLYGON_SMOOTH);
            }
            break;

         case 'm':
         case 'M':
            Mgla=!Mgla;
            break;

         case 'n':
         case 'N':
            NieruchomyPokoj=!NieruchomyPokoj;
            break;

         case 't':
         case 'T':
            Teksturowanie=!Teksturowanie;
            break;


         case VK_OEM_MINUS:
            NatezenieSwiatlaOtoczenia-=0.01;
            break;
         case VK_OEM_PLUS:
         case '=':
            NatezenieSwiatlaOtoczenia+=0.01;
            break;
      }
   }

   GL_RysujScene();
}
//---------------------------------------------------------------------------


void __fastcall TForm1::RysujSzescian(float krawedz) const
{
	const float a=krawedz;

   glBindTexture(GL_TEXTURE_2D,Tekstury[0]);
	glBegin(GL_QUADS);
	//tylnia
   glNormal3f(0,0,-1); //wektory normalne skierowane na zewnatrz
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,-a,-a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(-a,a,-a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(a,-a,-a);
	//przednia
   glNormal3f(0,0,1);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,-a,a);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(a,-a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-a,a,a);
   glEnd();

   glBindTexture(GL_TEXTURE_2D,Tekstury[1]);
	glBegin(GL_QUADS);
	//prawa
   glNormal3f(1,0,0);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(a,-a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,a,-a);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(a,-a,-a);
	//lewa
   glNormal3f(-1,0,0);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,-a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(-a,a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-a,a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,-a,-a);
   glEnd();

   glBindTexture(GL_TEXTURE_2D,Tekstury[2]);
	glBegin(GL_QUADS);
	//gorna
   glNormal3f(0,1,0);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,a,-a);
	//dolna
   glNormal3f(0,-1,0);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,-a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,-a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,-a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,-a,-a);
	glEnd();

   glBindTexture(GL_TEXTURE_2D,NULL);
}

void __fastcall TForm1::Oswietlenie()
{
   MlecznaZarowka();
   //ZoltaIZielonaMleczneZarowki();
   Reflektor();
}

void __fastcall TForm1::MlecznaZarowka()
{
   const float kolor1_rozproszone[]={0.5,0.5,0.5,1.0};
   glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor1_rozproszone);
   glEnable(GL_LIGHT1);
}

void __fastcall TForm1::ZoltaIZielonaMleczneZarowki()
{
   //zolta mleczna zarowka
	const float kolor_rozproszone_zolta[4]={1.0f,1.0f,0.0f,1.0f};
	const float pozycja_zolta[4]={-2.0f,0.0f,1.0f,1.0f};

	glLightfv(GL_LIGHT2,GL_POSITION,pozycja_zolta);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,kolor_rozproszone_zolta);
	glEnable(GL_LIGHT2);

   //zielona mleczna zarowka
	const float kolor_rozproszone_zielony[4]={0.0f,1.0f,0.0f,1.0f};
	const float pozycja_zielony[4]={2.0f,0.0f,1.0f,1.0f};

	glLightfv(GL_LIGHT3,GL_POSITION,pozycja_zielony);
	glLightfv(GL_LIGHT3,GL_DIFFUSE,kolor_rozproszone_zielony);
	glEnable(GL_LIGHT3);
}

void __fastcall TForm1::Reflektor()
{
   const float kolor_rozproszone[4]={0.3,0.3,0.3,1.0};
   const float kolor_reflektora[4]={1.0,1.0,1.0,1.0};
   const float pozycja[4]={0.0,-10.0,10.0,1.0};
   //const float pozycja[4]={2.0f,2.0f,-2.0f,1.0f};
   const szerokosc_wiazki=60.0; //w stopniach
   glLightfv(GL_LIGHT4,GL_POSITION,pozycja);
   glLightfv(GL_LIGHT4,GL_DIFFUSE,kolor_rozproszone);
   glLightfv(GL_LIGHT4,GL_SPECULAR,kolor_reflektora);
   glLightf(GL_LIGHT4,GL_SPOT_CUTOFF,szerokosc_wiazki);
   glEnable(GL_LIGHT4);
}

void __fastcall TForm1::Pomoc()
{
	AnsiString s=(AnsiString)"GLForm 1.1\n(c) Jacek Matulewski 2006-2007\n\n"+
			"OpenGL, wersja "+(char*)glGetString(GL_VERSION)+"\n"+
			"GLU, wersja "+(char*)gluGetString(GLU_VERSION);
   s+="\n\n+/- - Jasno wiata otoczenia\nstrzaki - ruch obiektu\n\nQ - Animacja\nB - Alpha blending\nA - Antyaliasing\nM - Mga\nN - Nieruchomy pokj\nT - Teksturowanie";
	MessageBox(Handle,s.c_str(),"TGLForm",MB_OK | MB_ICONINFORMATION);
}

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
   glDeleteTextures(TEKSTURY_ILOSC,Tekstury);
   glDeleteLists(czcionkaTimes3D,256);
}
//---------------------------------------------------------------------------


